﻿using System;
using System.Data;
using System.IO;
using System.Linq;
using System.Windows.Forms;
using static System.Environment;

namespace Spectral1.DATA_ACCESS
{
    public class DA_System
    {
        #region "==================== DECLARATIONS ==========================="
        private const Int32 MaxRecentFiles = 10;
        private DataSet_System.FileListTableDataTable _RecentlyUsedFileListDT = new DataSet_System.FileListTableDataTable();

        public bool flag_saving_or_loading = false;
        public bool flag_executing_sdl_code = false;
        public bool flag_suppress_patch_events = false;
        public bool flag_suppress_patch_set_events = false;
        public bool flag_initialising_system = true;
        public bool flag_importing_exporting = false;

        public bool flag_cloning_waveset = false;
        public bool flag_disable_waveform_update = false;
        public bool flag_initialising_waveset = false;
        public bool flag_suppress_ws_selection_change = false;

        //private DataSet_System.InputDevicesDataTable _DT_InputDevices = new DataSet_System.InputDevicesDataTable();
        //private DataSet_System.OutputDevicesDataTable _DT_OutputDevices = new DataSet_System.OutputDevicesDataTable();
        //private BindingSource _BS_input_devices = new BindingSource();
        //private BindingSource _BS_output_devices = new BindingSource();

        #endregion

        #region "==================== PROPERTIES ==========================="
        //public BindingSource BS_input_devices
        //{
        //    get
        //    {
        //        return _BS_input_devices;
        //    }
        //}

        //public BindingSource BS_output_devices
        //{
        //    get
        //    {
        //        return _BS_output_devices;
        //    }
        //}

        public string UserAppDataDirectory
        {
            get
            {
                return Environment.GetFolderPath(SpecialFolder.ApplicationData);
            }
        }

        public string TempDirectory
        {
            get
            {
                return UserAppDataDirectory + @"\Temp";
            }
        }

        public string RecentlyUsedFilepath
        {
            get
            {
                return TempDirectory + @"\RecentlyUsed.xml";
            }
        }

        #endregion


        #region "==================== EVENTS ==========================="


        #endregion

        #region "==================== METHODS ==========================="

        public  DA_System()
        {
            ////USB Devices
            //_BS_input_devices.DataSource = _DT_InputDevices;
            //_BS_input_devices.Sort = "ProductID ASC";

            //_BS_output_devices.DataSource = _DT_OutputDevices;
            //_BS_output_devices.Sort = "ProductID ASC";

            //Recent files
            if (Directory.Exists(TempDirectory) == false){Directory.CreateDirectory(TempDirectory);}
            if (File.Exists(RecentlyUsedFilepath) == false)
            {
                SaveRecentlyUsedFiles();
            }
            else
            {
                _RecentlyUsedFileListDT.ReadXml(RecentlyUsedFilepath);
            }
        }

        public void SaveRecentlyUsedFiles()
        {
            _RecentlyUsedFileListDT.WriteXml(RecentlyUsedFilepath);
        }

        public void AddFileToRecentlyUsed(string FilePath)
        {
            if (_RecentlyUsedFileListDT.FindByFilePath(FilePath) == null)
            {
                DataSet_System.FileListTableRow NewRow = _RecentlyUsedFileListDT.NewFileListTableRow();
                {
                    var withBlock = NewRow;
                    withBlock.FilePath = FilePath;
                    withBlock.Last_Updated = DateTime.Now;
                    withBlock.Status = 0;
                }
                _RecentlyUsedFileListDT.AddFileListTableRow(NewRow);
                Int32 UsedRows = _RecentlyUsedFileListDT.Select(null, "", DataViewRowState.CurrentRows).Count();
                if (UsedRows > MaxRecentFiles)
                {
                    _RecentlyUsedFileListDT.Select(null, "Last_updated ASC", DataViewRowState.CurrentRows).First().Delete();
                }
            }
            else
                _RecentlyUsedFileListDT.FindByFilePath(FilePath).Last_Updated = DateTime.Now;

            _RecentlyUsedFileListDT.AcceptChanges();
            SaveRecentlyUsedFiles();
        }

        public void RemoveFileFromRecentFileList(string FilePath)
        {
            if (_RecentlyUsedFileListDT.FindByFilePath(FilePath) != null)
            {
                _RecentlyUsedFileListDT.FindByFilePath(FilePath).Delete();
                _RecentlyUsedFileListDT.AcceptChanges();
                SaveRecentlyUsedFiles();
            }
        }

        public DataSet_System.FileListTableRow[] RecentlyUsedFileRows
        {
            get
            {
                return (DataSet_System.FileListTableRow[])(_RecentlyUsedFileListDT.Select(null, "Last_Updated DESC", DataViewRowState.CurrentRows));
            }
        }

        public string GetProductVersionNumber(bool ShortVersion)
        {
            if ((System.Deployment.Application.ApplicationDeployment.IsNetworkDeployed))
            {
                {
                    var withBlock = System.Deployment.Application.ApplicationDeployment.CurrentDeployment.CurrentVersion;
                    if (ShortVersion == true)
                        return withBlock.Major + "." + withBlock.Minor;
                    else
                        return withBlock.Major + "." + withBlock.Minor + "." + withBlock.Build + "." + withBlock.Revision;
                }
            }
            else
                return "";
        }

        public void RefreshMIDIDevices()
        {
            //Two important properties on all USB devices are its Vendor ID (VID) and Product ID (PID), which can be used to uniquely identify the device type by the operating system’s plug and play system

            //if (OutputDevice.DeviceCount != _DT_OutputDevices.Count)
            //{
            //    _DT_OutputDevices.Clear();
            //    for (int device = 0; device < OutputDevice.DeviceCount; device++)
            //    {
            //        try
            //        {
            //            using (OutputDevice outDevice = new OutputDevice(device))
            //            {
            //                Sanford.Multimedia.Midi.MidiOutCaps c = OutputDevice.GetDeviceCapabilities(outDevice.DeviceID);
            //                if (_DT_OutputDevices.FindByProductID(device) == null)
            //                { _DT_OutputDevices.AddOutputDevicesRow(c.name, device); }
            //            }
            //        }
            //        catch
            //        { }

            //    }
            //}


            //_DT_InputDevices.Clear();
            //for (int device = 0; device < InputDevice.DeviceCount; device++)
            //{
            //    try
            //    {
            //        using (InputDevice inDevice = new InputDevice(device))
            //        {
            //            Sanford.Multimedia.Midi.MidiInCaps c = InputDevice.GetDeviceCapabilities(inDevice.DeviceID);
            //            if (_DT_InputDevices.FindByProductID(device) == null)
            //            {
            //                _DT_InputDevices.AddInputDevicesRow(c.name, device);
            //            }
            //        }
            //    }
            //    catch
            //    {
            //        //Can have situations during unplugging the Device count is 0 AFTER it arrived at he 'using' above and so it fails.
            //    }

            //}
        }

        #endregion
    }
}
